/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.api;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import me.lucko.spark.api.Spark;
import me.lucko.spark.api.SparkProvider;
import me.lucko.spark.api.gc.GarbageCollector;
import me.lucko.spark.api.placeholder.PlaceholderResolver;
import me.lucko.spark.api.statistic.StatisticWindow;
import me.lucko.spark.api.statistic.misc.DoubleAverageInfo;
import me.lucko.spark.api.statistic.types.DoubleStatistic;
import me.lucko.spark.api.statistic.types.GenericStatistic;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.api.AbstractStatistic;
import me.lucko.spark.common.api.GarbageCollectorInfo;
import me.lucko.spark.common.monitor.cpu.CpuMonitor;
import me.lucko.spark.common.monitor.memory.GarbageCollectorStatistics;
import me.lucko.spark.common.monitor.tick.TickStatistics;
import me.lucko.spark.common.util.SparkPlaceholder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SparkApi
implements Spark {
    private static final Method SINGLETON_SET_METHOD;
    private final SparkPlatform platform;

    public SparkApi(SparkPlatform platform) {
        this.platform = platform;
    }

    public @NonNull DoubleStatistic<// Could not load outer class - annotation placement on inner may be incorrect
    StatisticWindow.CpuUsage> cpuProcess() {
        return new AbstractStatistic.Double<StatisticWindow.CpuUsage>("CPU Process Usage", StatisticWindow.CpuUsage.class){

            public double poll(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull StatisticWindow.CpuUsage window) {
                switch (window) {
                    case SECONDS_10: {
                        return CpuMonitor.processLoad10SecAvg();
                    }
                    case MINUTES_1: {
                        return CpuMonitor.processLoad1MinAvg();
                    }
                    case MINUTES_15: {
                        return CpuMonitor.processLoad15MinAvg();
                    }
                }
                throw new AssertionError(window);
            }
        };
    }

    public @NonNull DoubleStatistic<// Could not load outer class - annotation placement on inner may be incorrect
    StatisticWindow.CpuUsage> cpuSystem() {
        return new AbstractStatistic.Double<StatisticWindow.CpuUsage>("CPU System Usage", StatisticWindow.CpuUsage.class){

            public double poll(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull StatisticWindow.CpuUsage window) {
                switch (window) {
                    case SECONDS_10: {
                        return CpuMonitor.systemLoad10SecAvg();
                    }
                    case MINUTES_1: {
                        return CpuMonitor.systemLoad1MinAvg();
                    }
                    case MINUTES_15: {
                        return CpuMonitor.systemLoad15MinAvg();
                    }
                }
                throw new AssertionError(window);
            }
        };
    }

    public @Nullable DoubleStatistic<// Could not load outer class - annotation placement on inner may be incorrect
    StatisticWindow.TicksPerSecond> tps() {
        final TickStatistics stats = this.platform.getTickStatistics();
        if (stats == null) {
            return null;
        }
        return new AbstractStatistic.Double<StatisticWindow.TicksPerSecond>("Ticks Per Second", StatisticWindow.TicksPerSecond.class){

            public double poll(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull StatisticWindow.TicksPerSecond window) {
                switch (window) {
                    case SECONDS_5: {
                        return stats.tps5Sec();
                    }
                    case SECONDS_10: {
                        return stats.tps10Sec();
                    }
                    case MINUTES_1: {
                        return stats.tps1Min();
                    }
                    case MINUTES_5: {
                        return stats.tps5Min();
                    }
                    case MINUTES_15: {
                        return stats.tps15Min();
                    }
                }
                throw new AssertionError(window);
            }
        };
    }

    public @Nullable GenericStatistic<DoubleAverageInfo, // Could not load outer class - annotation placement on inner may be incorrect
    StatisticWindow.MillisPerTick> mspt() {
        final TickStatistics stats = this.platform.getTickStatistics();
        if (stats == null || !stats.isDurationSupported()) {
            return null;
        }
        return new AbstractStatistic.Generic<DoubleAverageInfo, StatisticWindow.MillisPerTick>("Milliseconds Per Tick", DoubleAverageInfo.class, StatisticWindow.MillisPerTick.class){

            public DoubleAverageInfo poll(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull StatisticWindow.MillisPerTick window) {
                switch (window) {
                    case SECONDS_10: {
                        return stats.duration10Sec();
                    }
                    case MINUTES_1: {
                        return stats.duration1Min();
                    }
                    case MINUTES_5: {
                        return stats.duration5Min();
                    }
                }
                throw new AssertionError(window);
            }
        };
    }

    public @NonNull Map<String, GarbageCollector> gc() {
        long serverUptime = System.currentTimeMillis() - this.platform.getServerNormalOperationStartTime();
        Map<String, GarbageCollectorStatistics> stats = GarbageCollectorStatistics.pollStatsSubtractInitial(this.platform.getStartupGcStatistics());
        HashMap<String, GarbageCollectorInfo> map = new HashMap<String, GarbageCollectorInfo>(stats.size());
        for (Map.Entry<String, GarbageCollectorStatistics> entry : stats.entrySet()) {
            map.put(entry.getKey(), new GarbageCollectorInfo(entry.getKey(), entry.getValue(), serverUptime));
        }
        return ImmutableMap.copyOf(map);
    }

    public @NonNull PlaceholderResolver placeholders() {
        return new PlaceholderResolver(){

            public @Nullable String resolveLegacyFormatting(@NonNull String placeholder) {
                return SparkPlaceholder.resolveFormattingCode(SparkApi.this.platform, placeholder);
            }

            public @Nullable String resolveComponentJson(@NonNull String placeholder) {
                return SparkPlaceholder.resolveComponentJson(SparkApi.this.platform, placeholder);
            }
        };
    }

    public static void register(Spark spark) {
        try {
            SINGLETON_SET_METHOD.invoke(null, spark);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static void unregister() {
        try {
            SINGLETON_SET_METHOD.invoke(null, new Object[]{null});
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            SINGLETON_SET_METHOD = SparkProvider.class.getDeclaredMethod("set", Spark.class);
            SINGLETON_SET_METHOD.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

