/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command;

import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.sender.CommandSender;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class CommandResponseHandler {
    private static final TextComponent PREFIX = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)"\u26a1", (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)" "))).build();
    private final SparkPlatform platform;
    private final CommandSender.Data senderData;
    private final WeakReference<CommandSender> sender;
    private String commandPrimaryAlias;

    public CommandResponseHandler(SparkPlatform platform, CommandSender sender) {
        this.platform = platform;
        this.senderData = sender.toData();
        this.sender = new WeakReference<CommandSender>(sender);
    }

    public void setCommandPrimaryAlias(String commandPrimaryAlias) {
        this.commandPrimaryAlias = commandPrimaryAlias;
    }

    public CommandSender.Data senderData() {
        return this.senderData;
    }

    public void allSenders(Consumer<? super CommandSender> action) {
        if (this.commandPrimaryAlias == null) {
            throw new IllegalStateException("Command alias has not been set!");
        }
        Set<? super CommandSender> senders = this.platform.getPlugin().getCommandSenders().filter(s -> s.hasPermission("spark") || s.hasPermission("spark." + this.commandPrimaryAlias)).collect(Collectors.toSet());
        CommandSender sender = (CommandSender)this.sender.get();
        if (sender != null) {
            senders.add(sender);
        }
        senders.forEach(action);
    }

    public void reply(Component message) {
        CommandSender sender = (CommandSender)this.sender.get();
        if (sender != null) {
            sender.sendMessage(message);
        }
    }

    public void reply(Iterable<Component> message) {
        Component joinedMsg = Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.newline()), message);
        this.reply(joinedMsg);
    }

    public void broadcast(Component message) {
        if (this.platform.shouldBroadcastResponse()) {
            this.allSenders(sender -> sender.sendMessage(message));
        } else {
            this.reply(message);
        }
    }

    public void broadcast(Iterable<Component> message) {
        if (this.platform.shouldBroadcastResponse()) {
            Component joinedMsg = Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.newline()), message);
            this.allSenders(sender -> sender.sendMessage(joinedMsg));
        } else {
            this.reply(message);
        }
    }

    public void replyPrefixed(Component message) {
        this.reply(CommandResponseHandler.applyPrefix(message));
    }

    public void broadcastPrefixed(Component message) {
        this.broadcast(CommandResponseHandler.applyPrefix(message));
    }

    public static Component applyPrefix(Component message) {
        return PREFIX.append(message);
    }
}

