/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import java.util.Locale;
import java.util.function.BiFunction;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.monitor.cpu.CpuMonitor;
import me.lucko.spark.common.monitor.tick.TickStatistics;
import me.lucko.spark.common.util.StatisticFormatter;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public enum SparkPlaceholder {
    TPS((platform, arg) -> {
        TickStatistics tickStatistics = platform.getTickStatistics();
        if (tickStatistics == null) {
            return null;
        }
        if (arg == null) {
            return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)StatisticFormatter.formatTps(tickStatistics.tps5Sec()))).append((Component)Component.text((String)", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps10Sec()))).append((Component)Component.text((String)", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps1Min()))).append((Component)Component.text((String)", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps5Min()))).append((Component)Component.text((String)", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps15Min()))).build();
        }
        switch (arg) {
            case "5s": {
                return StatisticFormatter.formatTps(tickStatistics.tps5Sec());
            }
            case "10s": {
                return StatisticFormatter.formatTps(tickStatistics.tps10Sec());
            }
            case "1m": {
                return StatisticFormatter.formatTps(tickStatistics.tps1Min());
            }
            case "5m": {
                return StatisticFormatter.formatTps(tickStatistics.tps5Min());
            }
            case "15m": {
                return StatisticFormatter.formatTps(tickStatistics.tps15Min());
            }
        }
        return null;
    }),
    TICKDURATION((platform, arg) -> {
        TickStatistics tickStatistics = platform.getTickStatistics();
        if (tickStatistics == null || !tickStatistics.isDurationSupported()) {
            return null;
        }
        if (arg == null) {
            return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)StatisticFormatter.formatTickDurations(tickStatistics.duration10Sec()))).append((Component)Component.text((String)";  "))).append((Component)StatisticFormatter.formatTickDurations(tickStatistics.duration1Min()))).build();
        }
        switch (arg) {
            case "10s": {
                return StatisticFormatter.formatTickDurations(tickStatistics.duration10Sec());
            }
            case "1m": {
                return StatisticFormatter.formatTickDurations(tickStatistics.duration1Min());
            }
        }
        return null;
    }),
    CPU_SYSTEM((platform, arg) -> {
        if (arg == null) {
            return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad10SecAvg()))).append((Component)Component.text((String)", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad1MinAvg()))).append((Component)Component.text((String)", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad15MinAvg()))).build();
        }
        switch (arg) {
            case "10s": {
                return StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad10SecAvg());
            }
            case "1m": {
                return StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad1MinAvg());
            }
            case "15m": {
                return StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad15MinAvg());
            }
        }
        return null;
    }),
    CPU_PROCESS((platform, arg) -> {
        if (arg == null) {
            return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad10SecAvg()))).append((Component)Component.text((String)", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad1MinAvg()))).append((Component)Component.text((String)", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad15MinAvg()))).build();
        }
        switch (arg) {
            case "10s": {
                return StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad10SecAvg());
            }
            case "1m": {
                return StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad1MinAvg());
            }
            case "15m": {
                return StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad15MinAvg());
            }
        }
        return null;
    });

    private final String name = this.name().toLowerCase(Locale.ROOT);
    private final BiFunction<SparkPlatform, String, TextComponent> function;

    private SparkPlaceholder(BiFunction<SparkPlatform, String, TextComponent> function) {
        this.function = function;
    }

    public String getName() {
        return this.name;
    }

    public TextComponent resolve(SparkPlatform platform, String arg) {
        return this.function.apply(platform, arg);
    }

    public static TextComponent resolveComponent(SparkPlatform platform, String placeholder) {
        String[] parts = placeholder.split("_");
        if (parts.length == 0) {
            return null;
        }
        String label = parts[0];
        if (label.equals("tps")) {
            String arg = parts.length < 2 ? null : parts[1];
            return TPS.resolve(platform, arg);
        }
        if (label.equals("tickduration")) {
            String arg = parts.length < 2 ? null : parts[1];
            return TICKDURATION.resolve(platform, arg);
        }
        if (label.equals("cpu") && parts.length >= 2) {
            String arg;
            String type = parts[1];
            String string = arg = parts.length < 3 ? null : parts[2];
            if (type.equals("system")) {
                return CPU_SYSTEM.resolve(platform, arg);
            }
            if (type.equals("process")) {
                return CPU_PROCESS.resolve(platform, arg);
            }
        }
        return null;
    }

    public static String resolveFormattingCode(SparkPlatform platform, String placeholder) {
        TextComponent result = SparkPlaceholder.resolveComponent(platform, placeholder);
        if (result == null) {
            return null;
        }
        return LegacyComponentSerializer.legacySection().serialize((Component)result);
    }

    public static String resolveComponentJson(SparkPlatform platform, String placeholder) {
        TextComponent result = SparkPlaceholder.resolveComponent(platform, placeholder);
        if (result == null) {
            return null;
        }
        return (String)GsonComponentSerializer.gson().serialize((Component)result);
    }
}

